/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class TurtleUpgradeRecipe
extends CustomRecipe {
    public TurtleUpgradeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x >= 3 && y >= 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack((ItemLike)ModRegistry.Items.TURTLE_NORMAL.get());
    }

    public boolean matches(CraftingInput inventory, Level world) {
        return !this.assemble(inventory, (HolderLookup.Provider)world.registryAccess()).isEmpty();
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider registryAccess) {
        ItemStack leftItem = ItemStack.EMPTY;
        ItemStack turtle = ItemStack.EMPTY;
        ItemStack rightItem = ItemStack.EMPTY;
        for (int y = 0; y < inventory.height(); ++y) {
            if (turtle.isEmpty()) {
                boolean finishedRow = false;
                for (int x = 0; x < inventory.width(); ++x) {
                    ItemStack item = inventory.getItem(x, y);
                    if (!item.isEmpty()) {
                        if (finishedRow) {
                            return ItemStack.EMPTY;
                        }
                        if (item.getItem() instanceof TurtleItem) {
                            if (turtle.isEmpty()) {
                                turtle = item;
                                continue;
                            }
                            return ItemStack.EMPTY;
                        }
                        if (turtle.isEmpty() && leftItem.isEmpty()) {
                            leftItem = item;
                            continue;
                        }
                        if (!turtle.isEmpty() && rightItem.isEmpty()) {
                            rightItem = item;
                            continue;
                        }
                        return ItemStack.EMPTY;
                    }
                    if (leftItem.isEmpty() && turtle.isEmpty()) continue;
                    finishedRow = true;
                }
                if (!turtle.isEmpty() || leftItem.isEmpty() && rightItem.isEmpty()) continue;
                return ItemStack.EMPTY;
            }
            for (int x = 0; x < inventory.width(); ++x) {
                ItemStack item = inventory.getItem(x, y);
                if (item.isEmpty()) continue;
                return ItemStack.EMPTY;
            }
        }
        if (turtle.isEmpty() || leftItem.isEmpty() && rightItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        UpgradeData[] upgrades = new UpgradeData[]{TurtleItem.getUpgradeWithData(turtle, TurtleSide.LEFT), TurtleItem.getUpgradeWithData(turtle, TurtleSide.RIGHT)};
        ItemStack[] items = new ItemStack[]{rightItem, leftItem};
        for (int i = 0; i < 2; ++i) {
            if (items[i].isEmpty()) continue;
            UpgradeData<ITurtleUpgrade> itemUpgrade = TurtleUpgrades.instance().get(registryAccess, items[i]);
            if (itemUpgrade == null || upgrades[i] != null) {
                return ItemStack.EMPTY;
            }
            upgrades[i] = itemUpgrade;
        }
        ItemStack newStack = turtle.copyWithCount(1);
        newStack.set((DataComponentType)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), (Object)upgrades[0]);
        newStack.set((DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), (Object)upgrades[1]);
        return newStack;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE_UPGRADE.get();
    }
}

